/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.rewrite;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.nodes.ASTError;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org2.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org2.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org2.eclipse.php.internal.core.ast.nodes.Assignment;
import org2.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org2.eclipse.php.internal.core.ast.nodes.Block;
import org2.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org2.eclipse.php.internal.core.ast.nodes.CastExpression;
import org2.eclipse.php.internal.core.ast.nodes.CatchClause;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org2.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org2.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org2.eclipse.php.internal.core.ast.nodes.DoStatement;
import org2.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org2.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org2.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org2.eclipse.php.internal.core.ast.nodes.ForStatement;
import org2.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org2.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org2.eclipse.php.internal.core.ast.nodes.FunctionName;
import org2.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org2.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org2.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.IfStatement;
import org2.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org2.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org2.eclipse.php.internal.core.ast.nodes.Include;
import org2.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.ListVariable;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org2.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org2.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.Quote;
import org2.eclipse.php.internal.core.ast.nodes.Reference;
import org2.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org2.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org2.eclipse.php.internal.core.ast.nodes.Scalar;
import org2.eclipse.php.internal.core.ast.nodes.SingleFieldDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.Statement;
import org2.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org2.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org2.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org2.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org2.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org2.eclipse.php.internal.core.ast.nodes.TryStatement;
import org2.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org2.eclipse.php.internal.core.ast.nodes.UseStatement;
import org2.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org2.eclipse.php.internal.core.ast.nodes.Variable;
import org2.eclipse.php.internal.core.ast.nodes.VariableBase;
import org2.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org2.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;
import org2.eclipse.php.internal.core.ast.visitor.AbstractVisitor;

public class ASTRewriteFlattener
extends AbstractVisitor {
    protected StringBuffer result;
    private RewriteEventStore store;

    public static String asString(ASTNode node, RewriteEventStore store) {
        ASTRewriteFlattener flattener = new ASTRewriteFlattener(store);
        node.accept(flattener);
        return flattener.getResult();
    }

    public ASTRewriteFlattener(RewriteEventStore store) {
        this.store = store;
        this.result = new StringBuffer();
    }

    public String getResult() {
        return new String(this.result.toString());
    }

    public void reset() {
        this.result.setLength(0);
    }

    public static void printModifiers(int modifiers, StringBuffer buf) {
        if (PHPFlags.isPublic(modifiers)) {
            buf.append("public ");
        }
        if (PHPFlags.isProtected(modifiers)) {
            buf.append("protected ");
        }
        if (PHPFlags.isPrivate(modifiers)) {
            buf.append("private ");
        }
        if (PHPFlags.isStatic(modifiers)) {
            buf.append("static ");
        }
        if (PHPFlags.isAbstract(modifiers)) {
            buf.append("abstract ");
        }
        if (PHPFlags.isFinal(modifiers)) {
            buf.append("final ");
        }
    }

    protected List getChildList(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        Object ret = this.getAttribute(parent, childProperty);
        if (ret instanceof List) {
            return (List)ret;
        }
        return Collections.EMPTY_LIST;
    }

    protected ASTNode getChildNode(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (ASTNode)this.getAttribute(parent, childProperty);
    }

    protected int getIntAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Integer)this.getAttribute(parent, childProperty);
    }

    protected boolean getBooleanAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        return (Boolean)this.getAttribute(parent, childProperty);
    }

    protected Object getAttribute(ASTNode parent, StructuralPropertyDescriptor childProperty) {
        if (this.store != null) {
            return this.store.getNewValue(parent, childProperty);
        }
        return null;
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator) {
        List list = this.getChildList(parent, childProperty);
        int i = 0;
        while (i < list.size()) {
            if (separator != null && i > 0) {
                this.result.append(separator);
            }
            ((ASTNode)list.get(i)).accept(this);
            ++i;
        }
    }

    protected void visitList(ASTNode parent, StructuralPropertyDescriptor childProperty, String separator, String lead, String post) {
        List list = this.getChildList(parent, childProperty);
        if (!list.isEmpty()) {
            this.result.append(lead);
            int i = 0;
            while (i < list.size()) {
                if (separator != null && i > 0) {
                    this.result.append(separator);
                }
                ((ASTNode)list.get(i)).accept(this);
                ++i;
            }
            this.result.append(post);
        }
    }

    @Override
    public boolean visit(ArrayAccess arrayAccess) {
        boolean isVariableHashtable;
        if (arrayAccess.getName() != null) {
            arrayAccess.getName().accept(this);
        }
        boolean bl = isVariableHashtable = arrayAccess.getArrayType() == 2;
        if (isVariableHashtable) {
            this.result.append('{');
        } else {
            this.result.append('[');
        }
        if (arrayAccess.getIndex() != null) {
            arrayAccess.getIndex().accept(this);
        }
        if (isVariableHashtable) {
            this.result.append('}');
        } else {
            this.result.append(']');
        }
        return false;
    }

    @Override
    public boolean visit(ArrayCreation arrayCreation) {
        this.result.append("array(");
        ArrayElement[] elements = arrayCreation.getElements();
        int i = 0;
        while (i < elements.length) {
            elements[i].accept(this);
            this.result.append(",");
            ++i;
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(ArrayElement arrayElement) {
        if (arrayElement.getKey() != null) {
            arrayElement.getKey().accept(this);
            this.result.append("=>");
        }
        arrayElement.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(Assignment assignment) {
        assignment.getLeftHandSide().accept(this);
        this.result.append(Assignment.getOperator(assignment.getOperator()));
        assignment.getRightHandSide().accept(this);
        return false;
    }

    @Override
    public boolean visit(ASTError astError) {
        return false;
    }

    @Override
    public boolean visit(BackTickExpression backTickExpression) {
        this.result.append("`");
        Expression[] expressions = backTickExpression.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            expressions[i].accept(this);
            ++i;
        }
        this.result.append("`");
        return false;
    }

    @Override
    public boolean visit(Block block) {
        if (block.isCurly()) {
            this.result.append("{\n");
        } else {
            this.result.append(":\n");
        }
        this.visitList(block, Block.STATEMENTS_PROPERTY, null);
        if (block.isCurly()) {
            this.result.append("}\n");
        } else {
            StructuralPropertyDescriptor locationInParent = block.getLocationInParent();
            if (locationInParent == IfStatement.TRUE_STATEMENT_PROPERTY) {
                if (((IfStatement)block.getParent()).getFalseStatement() == null) {
                    this.result.append("endif;\n");
                } else {
                    this.result.append("\n");
                }
            } else if (locationInParent == IfStatement.FALSE_STATEMENT_PROPERTY) {
                this.result.append("endif;\n");
            } else if (locationInParent == WhileStatement.BODY_PROPERTY) {
                this.result.append("endwhile;\n");
            } else if (locationInParent == ForStatement.BODY_PROPERTY) {
                this.result.append("endfor;\n");
            } else if (locationInParent == ForEachStatement.STATEMENT_PROPERTY) {
                this.result.append("endforeach;\n");
            } else if (locationInParent == SwitchStatement.BODY_PROPERTY) {
                this.result.append("endswitch;\n");
            }
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement breakStatement) {
        this.result.append("break");
        if (breakStatement.getExpr() != null) {
            this.result.append(' ');
            breakStatement.getExpr().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(CastExpression castExpression) {
        this.result.append("(");
        this.result.append(CastExpression.getCastType(castExpression.getCastType()));
        this.result.append(")");
        castExpression.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(CatchClause catchClause) {
        this.result.append("catch (");
        catchClause.getClassName().accept(this);
        this.result.append(" ");
        catchClause.getVariable().accept(this);
        this.result.append(") ");
        catchClause.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(ConstantDeclaration classConstantDeclaration) {
        this.result.append("const ");
        boolean isFirst = true;
        Identifier[] variableNames = classConstantDeclaration.getVariableNames();
        Expression[] constantValues = classConstantDeclaration.getConstantValues();
        int i = 0;
        while (i < variableNames.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            variableNames[i].accept(this);
            this.result.append(" = ");
            constantValues[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ClassDeclaration classDeclaration) {
        Identifier[] interfaces;
        int modifier = classDeclaration.getModifier();
        if (modifier != 0) {
            this.result.append(ClassDeclaration.getModifier(modifier));
            this.result.append(' ');
        }
        this.result.append("class ");
        classDeclaration.getName().accept(this);
        if (classDeclaration.getSuperClass() != null) {
            this.result.append(" extends ");
            classDeclaration.getSuperClass().accept(this);
        }
        if ((interfaces = classDeclaration.getInterfaces()) != null && interfaces.length != 0) {
            this.result.append(" implements ");
            interfaces[0].accept(this);
            int i = 1;
            while (i < interfaces.length) {
                this.result.append(" , ");
                interfaces[i].accept(this);
                ++i;
            }
        }
        classDeclaration.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.result.append("new ");
        classInstanceCreation.getClassName().accept(this);
        Expression[] ctorParams = classInstanceCreation.getCtorParams();
        if (ctorParams.length != 0) {
            this.result.append("(");
            ctorParams[0].accept(this);
            int i = 1;
            while (i < ctorParams.length) {
                this.result.append(",");
                ctorParams[i].accept(this);
                ++i;
            }
            this.result.append(")");
        }
        return false;
    }

    @Override
    public boolean visit(ClassName className) {
        className.getClassName().accept(this);
        return false;
    }

    @Override
    public boolean visit(CloneExpression cloneExpression) {
        this.result.append("clone ");
        cloneExpression.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(Comment comment) {
        this.result.append(this.getComment(comment));
        this.result.append("\n");
        return false;
    }

    public String getComment(Comment comment) {
        if (comment.getCommentType() == 0) {
            return "//";
        }
        if (comment.getCommentType() == 1) {
            return "/* */";
        }
        if (comment.getCommentType() == 2) {
            return "/** */";
        }
        return null;
    }

    @Override
    public boolean visit(ConditionalExpression conditionalExpression) {
        conditionalExpression.getCondition().accept(this);
        this.result.append(" ? ");
        conditionalExpression.getIfTrue().accept(this);
        this.result.append(" : ");
        conditionalExpression.getIfFalse().accept(this);
        return false;
    }

    @Override
    public boolean visit(ContinueStatement continueStatement) {
        this.result.append("continue ");
        if (continueStatement.getExpr() != null) {
            continueStatement.getExpr().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(DeclareStatement declareStatement) {
        this.result.append("declare (");
        boolean isFirst = true;
        Identifier[] directiveNames = declareStatement.getDirectiveNames();
        Expression[] directiveValues = declareStatement.getDirectiveValues();
        int i = 0;
        while (i < directiveNames.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            directiveNames[i].accept(this);
            this.result.append(" = ");
            directiveValues[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(")");
        declareStatement.getAction().accept(this);
        return false;
    }

    @Override
    public boolean visit(DoStatement doStatement) {
        this.result.append("do ");
        Statement body = doStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.result.append("while (");
        Expression cond = doStatement.getCondition();
        if (cond != null) {
            cond.accept(this);
        }
        this.result.append(");\n");
        return false;
    }

    @Override
    public boolean visit(EchoStatement echoStatement) {
        this.result.append("echo ");
        List<Expression> expressions = echoStatement.expressions();
        int i = 0;
        while (i < expressions.size()) {
            expressions.get(i).accept(this);
            if (i + 1 < expressions.size()) {
                this.result.append(", ");
            }
            ++i;
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement emptyStatement) {
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement expressionStatement) {
        if (expressionStatement.getExpression() != null) {
            expressionStatement.getExpression().accept(this);
            this.result.append(";\n");
        } else {
            this.result.append("Missing();");
        }
        return false;
    }

    @Override
    public boolean visit(FieldAccess fieldAccess) {
        fieldAccess.getDispatcher().accept(this);
        this.result.append("->");
        fieldAccess.getField().accept(this);
        return false;
    }

    @Override
    public boolean visit(FieldsDeclaration fieldsDeclaration) {
        Variable[] variableNames = fieldsDeclaration.getVariableNames();
        Expression[] initialValues = fieldsDeclaration.getInitialValues();
        int i = 0;
        while (i < variableNames.length) {
            this.result.append(String.valueOf(fieldsDeclaration.getModifierString()) + " ");
            variableNames[i].accept(this);
            if (initialValues[i] != null) {
                this.result.append(" = ");
                initialValues[i].accept(this);
            }
            this.result.append(";\n");
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(ForEachStatement forEachStatement) {
        Expression value;
        this.result.append("foreach (");
        Expression express = forEachStatement.getExpression();
        if (express != null) {
            express.accept(this);
        }
        this.result.append(" as ");
        if (forEachStatement.getKey() != null) {
            forEachStatement.getKey().accept(this);
            this.result.append(" => ");
        }
        if ((value = forEachStatement.getValue()) != null) {
            value.accept(this);
        }
        this.result.append(")");
        forEachStatement.getStatement().accept(this);
        return false;
    }

    @Override
    public boolean visit(NamespaceDeclaration namespaceDeclaration) {
        this.result.append("namespace ");
        namespaceDeclaration.childrenAccept(this);
        if (namespaceDeclaration.getBody() == null) {
            this.result.append(";\n");
        }
        return false;
    }

    @Override
    public boolean visit(NamespaceName namespaceName) {
        if (namespaceName.isGlobal()) {
            this.result.append("\\");
        }
        if (namespaceName.isCurrent()) {
            this.result.append("namespace\\");
        }
        List<Identifier> segments = namespaceName.segments();
        Iterator<Identifier> it = segments.iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.result.append("\\");
        }
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        this.result.append("use ");
        Iterator<UseStatementPart> it = useStatement.parts().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.result.append(", ");
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(UseStatementPart useStatementPart) {
        useStatementPart.getName().accept(this);
        Identifier alias = useStatementPart.getAlias();
        if (alias != null) {
            this.result.append(" as ");
            alias.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FormalParameter formalParameter) {
        Expression paramType;
        if (formalParameter.isMandatory() && formalParameter.getAST().apiLevel() == PHPVersion.PHP4) {
            this.result.append("const ");
        }
        if ((paramType = formalParameter.getParameterType()) != null) {
            paramType.accept(this);
            this.result.append(' ');
        }
        formalParameter.getParameterName().accept(this);
        Expression defaultValue = formalParameter.getDefaultValue();
        if (defaultValue != null) {
            this.result.append(" = ");
            defaultValue.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        boolean isFirst = true;
        this.result.append("for (");
        Expression[] initializations = forStatement.getInitializations();
        Expression[] conditions = forStatement.getConditions();
        Expression[] increasements = forStatement.getIncreasements();
        int i = 0;
        while (i < initializations.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            initializations[i].accept(this);
            isFirst = false;
            ++i;
        }
        isFirst = true;
        this.result.append(" ; ");
        i = 0;
        while (i < conditions.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            conditions[i].accept(this);
            isFirst = false;
            ++i;
        }
        isFirst = true;
        this.result.append(" ; ");
        i = 0;
        while (i < increasements.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            increasements[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(" ) ");
        Statement body = forStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionDeclaration functionDeclaration) {
        this.result.append(" function ");
        if (functionDeclaration.isReference()) {
            this.result.append('&');
        }
        functionDeclaration.getFunctionName().accept(this);
        this.result.append('(');
        List<FormalParameter> formalParametersList = functionDeclaration.formalParameters();
        FormalParameter[] formalParameters = formalParametersList.toArray(new FormalParameter[formalParametersList.size()]);
        if (formalParameters.length != 0) {
            formalParameters[0].accept(this);
            int i = 1;
            while (i < formalParameters.length) {
                this.result.append(", ");
                formalParameters[i].accept(this);
                ++i;
            }
        }
        this.result.append(')');
        Block body = functionDeclaration.getBody();
        if (body != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        functionInvocation.getFunctionName().accept(this);
        this.result.append('(');
        Expression[] parameters = functionInvocation.getParameters();
        if (parameters.length != 0) {
            parameters[0].accept(this);
            int i = 1;
            while (i < parameters.length) {
                this.result.append(',');
                parameters[i].accept(this);
                ++i;
            }
        }
        this.result.append(')');
        return false;
    }

    @Override
    public boolean visit(FunctionName functionName) {
        functionName.getFunctionName().accept(this);
        return false;
    }

    @Override
    public boolean visit(GlobalStatement globalStatement) {
        this.result.append("global ");
        boolean isFirst = true;
        Variable[] variables = globalStatement.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            variables[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(";\n ");
        return false;
    }

    @Override
    public boolean visit(GotoLabel gotoLabel) {
        gotoLabel.getName().accept(this);
        this.result.append(":\n ");
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        this.result.append("goto ");
        gotoStatement.getLabel().accept(this);
        this.result.append(";\n ");
        return false;
    }

    @Override
    public boolean visit(Identifier identifier) {
        this.result.append(identifier.getName());
        return false;
    }

    @Override
    public boolean visit(IfStatement ifStatement) {
        this.result.append("if(");
        Expression cond = ifStatement.getCondition();
        if (cond != null) {
            cond.accept(this);
        }
        this.result.append(")");
        Statement trueStatement = ifStatement.getTrueStatement();
        if (trueStatement != null) {
            trueStatement.accept(this);
        }
        if (ifStatement.getFalseStatement() != null) {
            this.result.append("else");
            ifStatement.getFalseStatement().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(IgnoreError ignoreError) {
        this.result.append("@");
        ignoreError.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(Include include) {
        this.result.append(Include.getType(include.getIncludeType()));
        this.result.append(" (");
        include.getExpr().accept(this);
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(InfixExpression infixExpression) {
        infixExpression.getLeft().accept(this);
        this.result.append(' ');
        this.result.append(InfixExpression.getOperator(infixExpression.getOperator()));
        this.result.append(' ');
        infixExpression.getRight().accept(this);
        return false;
    }

    @Override
    public boolean visit(InLineHtml inLineHtml) {
        return false;
    }

    @Override
    public boolean visit(InstanceOfExpression instanceOfExpression) {
        instanceOfExpression.getExpr().accept(this);
        this.result.append(" instanceof ");
        instanceOfExpression.getClassName().accept(this);
        return false;
    }

    @Override
    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.result.append("interface ");
        interfaceDeclaration.getName().accept(this);
        this.result.append(" extends ");
        boolean isFirst = true;
        Identifier[] interfaces = interfaceDeclaration.getInterfaces();
        int i = 0;
        while (interfaces != null && i < interfaces.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            interfaces[i].accept(this);
            isFirst = false;
            ++i;
        }
        interfaceDeclaration.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ListVariable listVariable) {
        this.result.append("list(");
        boolean isFirst = true;
        VariableBase[] variables = listVariable.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            variables[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(LambdaFunctionDeclaration functionDeclaration) {
        this.result.append(" function ");
        if (functionDeclaration.isReference()) {
            this.result.append('&');
        }
        this.result.append('(');
        List<FormalParameter> formalParametersList = functionDeclaration.formalParameters();
        Iterator<FormalParameter> paramIt = formalParametersList.iterator();
        while (paramIt.hasNext()) {
            paramIt.next().accept(this);
            if (!paramIt.hasNext()) continue;
            this.result.append(", ");
        }
        this.result.append(')');
        List<Expression> lexicalVariables = functionDeclaration.lexicalVariables();
        if (lexicalVariables.size() > 0) {
            this.result.append(" use (");
            Iterator<Expression> it = lexicalVariables.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.result.append(", ");
            }
            this.result.append(')');
        }
        if (functionDeclaration.getBody() != null) {
            functionDeclaration.getBody().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration) {
        Comment comment = methodDeclaration.getComment();
        if (comment != null) {
            comment.accept(this);
        }
        this.result.append(methodDeclaration.getModifierString());
        methodDeclaration.getFunction().accept(this);
        return false;
    }

    @Override
    public boolean visit(MethodInvocation methodInvocation) {
        methodInvocation.getDispatcher().accept(this);
        this.result.append("->");
        methodInvocation.getMethod().accept(this);
        return false;
    }

    @Override
    public boolean visit(ParenthesisExpression parenthesisExpression) {
        this.result.append("(");
        if (parenthesisExpression.getExpr() != null) {
            parenthesisExpression.getExpr().accept(this);
        }
        this.result.append(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression postfixExpressions) {
        postfixExpressions.getVariable().accept(this);
        this.result.append(PostfixExpression.getOperator(postfixExpressions.getOperator()));
        return false;
    }

    @Override
    public boolean visit(PrefixExpression prefixExpression) {
        prefixExpression.getVariable().accept(this);
        this.result.append(PrefixExpression.getOperator(prefixExpression.getOperator()));
        return false;
    }

    @Override
    public boolean visit(Program program) {
        boolean isPhpState = false;
        Statement[] statements = program.getStatements();
        int i = 0;
        while (i < statements.length) {
            boolean isHtml = statements[i] instanceof InLineHtml;
            if (!isHtml && !isPhpState) {
                this.result.append("<?php\n");
                statements[i].accept(this);
                isPhpState = true;
            } else if (!isHtml && isPhpState) {
                statements[i].accept(this);
                this.result.append("\n");
            } else if (isHtml && isPhpState) {
                this.result.append("?>\n");
                statements[i].accept(this);
                this.result.append("\n");
                isPhpState = false;
            } else {
                statements[i].accept(this);
                this.result.append("\n");
            }
            ++i;
        }
        if (isPhpState) {
            this.result.append("?>\n");
        }
        Collection<Comment> comments = program.getComments();
        for (Comment comment : comments) {
            comment.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(Quote quote) {
        switch (quote.getQuoteType()) {
            case 0: {
                this.result.append("\"");
                this.acceptQuoteExpression(quote.getExpressions());
                this.result.append("\"");
                break;
            }
            case 1: {
                this.result.append("'");
                this.acceptQuoteExpression(quote.getExpressions());
                this.result.append("'");
                break;
            }
            case 2: {
                this.result.append("<<<Heredoc\n");
                this.acceptQuoteExpression(quote.getExpressions());
                this.result.append("\nHeredoc");
            }
        }
        return false;
    }

    @Override
    public boolean visit(Reference reference) {
        this.result.append("&");
        reference.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(ReflectionVariable reflectionVariable) {
        this.result.append("$");
        reflectionVariable.getVariableName().accept(this);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement returnStatement) {
        this.result.append("return ");
        if (returnStatement.getExpr() != null) {
            returnStatement.getExpr().accept(this);
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(Scalar scalar) {
        if (scalar.getScalarType() != 3) {
            this.result.append(scalar.getStringValue());
        }
        return false;
    }

    @Override
    public boolean visit(StaticConstantAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.result.append("::");
        staticFieldAccess.getConstant().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticFieldAccess staticFieldAccess) {
        staticFieldAccess.getClassName().accept(this);
        this.result.append("::");
        staticFieldAccess.getField().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticMethodInvocation staticMethodInvocation) {
        staticMethodInvocation.getClassName().accept(this);
        this.result.append("::");
        staticMethodInvocation.getMethod().accept(this);
        return false;
    }

    @Override
    public boolean visit(StaticStatement staticStatement) {
        this.result.append("static ");
        boolean isFirst = true;
        Expression[] expressions = staticStatement.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (!isFirst) {
                this.result.append(", ");
            }
            expressions[i].accept(this);
            isFirst = false;
            ++i;
        }
        this.result.append(";\n");
        return false;
    }

    @Override
    public boolean visit(SwitchCase switchCase) {
        if (switchCase.isDefault()) {
            this.result.append("default:\n");
        } else {
            this.result.append("case ");
            if (switchCase.getValue() != null) {
                switchCase.getValue().accept(this);
                this.result.append(":\n");
            }
        }
        Statement[] actions2 = switchCase.getActions();
        int i = 0;
        while (i < actions2.length) {
            actions2[i].accept(this);
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(SwitchStatement switchStatement) {
        this.result.append("switch (");
        Expression express = switchStatement.getExpression();
        if (express != null) {
            express.accept(this);
        }
        this.result.append(")");
        Block statment = switchStatement.getBody();
        if (statment != null) {
            statment.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ThrowStatement throwStatement) {
        throwStatement.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        this.result.append("try ");
        Block body = tryStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        List<CatchClause> catchClauses = tryStatement.catchClauses();
        int i = 0;
        while (i < catchClauses.size()) {
            catchClauses.get(i).accept(this);
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(UnaryOperation unaryOperation) {
        this.result.append(UnaryOperation.getOperator(unaryOperation.getOperator()));
        unaryOperation.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(Variable variable) {
        if (variable.isDollared()) {
            this.result.append("$");
        }
        variable.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(WhileStatement whileStatement) {
        this.result.append("while (");
        Expression condition = whileStatement.getCondition();
        if (condition != null) {
            whileStatement.getCondition().accept(this);
        }
        this.result.append(")\n");
        Statement body = whileStatement.getBody();
        if (body != null) {
            body.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SingleFieldDeclaration singleFieldDeclaration) {
        singleFieldDeclaration.getName().accept(this);
        Expression value = singleFieldDeclaration.getValue();
        if (value != null) {
            this.result.append(" = ");
            value.accept(this);
        }
        return false;
    }

    private void acceptQuoteExpression(Expression[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            expressions[i].accept(this);
            ++i;
        }
    }
}

